setDefaultTab("Healing")
UI.Separator()

-- ========================
-- STORAGE
-- ========================
if not storage.swapAmulet then
  storage.swapAmulet = {
    mode = "hp",      -- "hp" ou "mp"
    hpPercent = 50,
    mpPercent = 30,
    highAmuletId = 0,
    lowAmuletId = 0
  }
end

local config = storage.swapAmulet

-- ========================
-- UI BUTTON
-- ========================


local ui = setupUI([[
Panel
  height: 19

  Button
    id: setup
    anchors.left: parent.left
    anchors.right: parent.right
    height: 17
    text: Setup Swap Amulet
]])
ui:setId("swapAmulet")

-- ========================
-- SETUP WINDOW
-- ========================
local rootWidget = g_ui.getRootWidget()
local window

if rootWidget then
  window = UI.createWindow("swapAmuletWindow", rootWidget)
  window:hide()

  window.closeButton.onClick = function()
    window:hide()
  end


    -- MODE
    local modePanel = window:getChildById('modePanel')
    local hpMode = modePanel:getChildById('hpMode')
    local mpMode = modePanel:getChildById('mpMode')

    local function refreshMode()
    hpMode:setOn(config.mode == "hp")
    mpMode:setOn(config.mode == "mp")
    end

    hpMode.onClick = function()
    config.mode = "hp"
    refreshMode()
    end

    mpMode.onClick = function()
    config.mode = "mp"
    refreshMode()
    end

  refreshMode()

  -- HP SCROLL
  window.hpScroll:setValue(config.hpPercent)
  window.hpText:setText("HP % <= " .. config.hpPercent)

  window.hpScroll.onValueChange = function(_, value)
    config.hpPercent = value
    window.hpText:setText("HP % <= " .. value)
  end

  -- MP SCROLL
  window.mpScroll:setValue(config.mpPercent)
  window.mpText:setText("MP % <= " .. config.mpPercent)

  window.mpScroll.onValueChange = function(_, value)
    config.mpPercent = value
    window.mpText:setText("MP % <= " .. value)
  end

     -- AMULETS (busca correta pela hierarquia)
    local amuletsPanel = window:getChildById('amuletsPanel')

    local highPanel = amuletsPanel:getChildren()[1]
    local lowPanel  = amuletsPanel:getChildren()[2]

    local highAmulet = highPanel:getChildById('highAmulet')
    local lowAmulet  = lowPanel:getChildById('lowAmulet')

    highAmulet.onItemChange = function(widget)
    config.highAmuletId = widget:getItemId()
    end
    highAmulet:setItemId(config.highAmuletId)

    lowAmulet.onItemChange = function(widget)
    config.lowAmuletId = widget:getItemId()
    end
    lowAmulet:setItemId(config.lowAmuletId)

end

ui.setup.onClick = function()
  window:show()
  window:raise()
  window:focus()
end

-- ========================
-- HELPERS
-- ========================
local function getEquippedAmuletId()
  local amulet = getNeck()
  return amulet and amulet:getId() or 0
end

local function equipAmulet(id)
  if id == 0 then return end
  equipItem(id, 2) -- neck
end

-- ========================
-- MAIN MACRO
-- ========================
macro(200, "Swap amulet", function()
  if config.highAmuletId == 0 or config.lowAmuletId == 0 then
    return
  end

  local percent
  if config.mode == "hp" then
    percent = hppercent()
    if percent <= config.hpPercent then
      if getEquippedAmuletId() ~= config.lowAmuletId then
        equipAmulet(config.lowAmuletId)
      end
    else
      if getEquippedAmuletId() ~= config.highAmuletId then
        equipAmulet(config.highAmuletId)
      end
    end
  else
    percent = manapercent()
    if percent <= config.mpPercent then
      if getEquippedAmuletId() ~= config.lowAmuletId then
        equipAmulet(config.lowAmuletId)
      end
    else
      if getEquippedAmuletId() ~= config.highAmuletId then
        equipAmulet(config.highAmuletId)
      end
    end
  end
end)
